USE wiffzack

use wiffzack

SELECT dbschemas.[name] as 'Schema',
dbtables.[name] as 'Table',
dbindexes.[name] as 'Index',
indexstats.avg_fragmentation_in_percent,
indexstats.page_count
FROM sys.dm_db_index_physical_stats (DB_ID(N'wiffzack'), NULL, NULL, NULL, 'DETAILED') AS indexstats
LEFT JOIN sys.tables dbtables on dbtables.[object_id] = indexstats.[object_id]
LEFT JOIN sys.schemas dbschemas on dbtables.[schema_id] = dbschemas.[schema_id]
LEFT JOIN sys.indexes AS dbindexes ON dbindexes.[object_id] = indexstats.[object_id]
AND indexstats.index_id = dbindexes.index_id
ORDER BY indexstats.avg_fragmentation_in_percent desc;
   
  
DECLARE @TableName varchar(255)
DECLARE @stmt nvarchar(2000)  
DECLARE TableCursor CURSOR FOR    
SELECT table_name FROM information_schema.tables    
WHERE table_type = 'base table'    
   
  
OPEN TableCursor  
  
FETCH NEXT FROM TableCursor INTO @TableName    
WHILE @@FETCH_STATUS = 0    
BEGIN  
  
 SET @stmt = N'ALTER INDEX ALL ON ' + @TableName + N' REBUILD'
 print @stmt
 EXECUTE sp_executesql @stmt
 
  
FETCH NEXT FROM TableCursor INTO @TableName  
  
END  
  
   
  
CLOSE TableCursor  
  
   
  
DEALLOCATE TableCursor 